
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Thu Jan 13 16:26:50 2005
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version CRYS_ATP_TST_UTIL_Funcs.c#1:csrc:1
   *  \author doronp
   *  \remarks Copyright (C) 2007 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
/* canceling the lint warning: */
/*lint --e{718} */
/*lint --e{746} */
/*lint --e{826} */


/***** Include Files ******/
#include "CRYS.h"

#include "CRYS_ATP_TST_Defines.h"
#include "CRYS_ATP_TST_main.h"
#include "CRYS_ATP_TST_UTIL_Funcs.h"

#include "DX_VOS_Mem.h"
#include "DX_VOS_File.h"
#include "DX_VOS_Timer.h"
#include <stdio.h>


extern char *TST_log_fname_ptr;

/******** Defines ********/
/******** Enums **********/
/******** Typedefs *********/
/******** Global Data ********/



/***************************
* Function Name:
* CRYS_ATP_TST_PrintHASHType
* Inputs:
*  CRYS_HASH_OperationMode_t HASHType - Hash type to Print out
*
* Outputs:
*  None
*
* Description:
* This function prints the CRYS version and sub versions
*
**************************/
void CRYS_ATP_TST_PrintHASHType(CRYS_HASH_OperationMode_t TST_HashType)
{
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG," Hash Type used - "));
    switch(TST_HashType)
    {
    case CRYS_HASH_SHA1_mode:
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"CRYS_HASH_SHA1_mode \n"));
        break;
    case CRYS_HASH_SHA224_mode:
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"CRYS_HASH_SHA224_mode \n"));
        break;
    case CRYS_HASH_SHA256_mode:
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"CRYS_HASH_SHA256_mode \n"));
        break;
    case CRYS_HASH_SHA384_mode:
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"CRYS_HASH_SHA384_mode \n"));
        break;
    case CRYS_HASH_SHA512_mode:
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"CRYS_HASH_SHA512_mode \n"));
        break;
    case CRYS_HASH_MD5_mode:
        ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"CRYS_HASH_MD5_mode \n"));
         break;
    default:
        break;
    }
}
/***************************
 * Function Name:
 * CRYS_ATP_TST_ShowCRYSVersion
 * Inputs:
 *  none
 *
 * Outputs:
 *  CRYSError_t - Function error return
 *
 * Description:
 * This function prints the CRYS version and sub versions
 *
 **************************/
void CRYS_ATP_TST_ShowCRYSVersion(void)
{
    /*Printing the CRYS version and Engines */
    /*--------------------------------------*/
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n--------------[ CRYS VERSION ]-----------------------------------"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n CRYS VERSION  - %c%c%c%c-%c%d,%d,%d,%d",
                                         TST_ATP_CRYS_version.CRYS_Version.compName[0],
                                         TST_ATP_CRYS_version.CRYS_Version.compName[1],
                                         TST_ATP_CRYS_version.CRYS_Version.compName[2],
                                         TST_ATP_CRYS_version.CRYS_Version.compName[3],
                                         TST_ATP_CRYS_version.CRYS_Version.type,
                                         TST_ATP_CRYS_version.CRYS_Version.major,
                                         TST_ATP_CRYS_version.CRYS_Version.minor,
                                         TST_ATP_CRYS_version.CRYS_Version.sub,
                                         TST_ATP_CRYS_version.CRYS_Version.internal));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n-----------------------------------------------------------------"));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n CRYS LLF_HASH_Version - %c%c%c%c",
                                         TST_ATP_CRYS_version.LLF_HASH_Version.compName[0],
                                         TST_ATP_CRYS_version.LLF_HASH_Version.compName[1],
                                         TST_ATP_CRYS_version.LLF_HASH_Version.compName[2],
                                         TST_ATP_CRYS_version.LLF_HASH_Version.compName[3]));
                                         switch(TST_ATP_CRYS_version.LLF_HASH_Version.type)
                                         {
                                            case CRYS_DEFS_SW_ENGINE_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-SW_ENGINE"));
                                            break;
                                            case CRYS_DEFS_CC_LITE_ENGINE_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-CC_LITE_ENGINE"));
                                            break;
                                            case CRYS_DEFS_CC_LITE_PKI256_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-CC_LITE_PKI256"));
                                            break;
                                            case CRYS_DEFS_SSDMA_ENGINE_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-SSDMA_ENGINE"));
                                            break;
                                            case CRYS_DEFS_SSDMA_2_ENGINE_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-SSDMA_2_ENGINE"));
                                            break;
                                            case CRYS_DEFS_NOT_SUPPORTED:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-ENGINE_NOT_SUPPORTED"));
                                            break;
                                            default:
                                            break;
                                         };
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-%d,%d,%d,%d",
                                         TST_ATP_CRYS_version.LLF_HASH_Version.major,
                                         TST_ATP_CRYS_version.LLF_HASH_Version.minor,
                                         TST_ATP_CRYS_version.LLF_HASH_Version.sub,
                                         TST_ATP_CRYS_version.LLF_HASH_Version.internal));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n CRYS LLF_AES_Version  - %c%c%c",
                                         TST_ATP_CRYS_version.LLF_AES_Version.compName[0],
                                         TST_ATP_CRYS_version.LLF_AES_Version.compName[1],
                                         TST_ATP_CRYS_version.LLF_AES_Version.compName[2]));
                                         switch(TST_ATP_CRYS_version.LLF_AES_Version.type)
                                         {
                                            case CRYS_DEFS_SW_ENGINE_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-SW_ENGINE"));
                                            break;
                                            case CRYS_DEFS_CC_LITE_ENGINE_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-CC_LITE_ENGINE"));
                                            break;
                                            case CRYS_DEFS_CC_LITE_PKI256_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-CC_LITE_PKI256"));
                                            break;
                                            case CRYS_DEFS_SSDMA_ENGINE_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-SSDMA_ENGINE"));
                                            break;
                                            case CRYS_DEFS_OTHER_ENGINE_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-SW & HW KP ENGINE"));
                                            break;
                                            case CRYS_DEFS_SSDMA_2_ENGINE_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-SSDMA_2_ENGINE"));
                                            break;
                                            case CRYS_DEFS_NOT_SUPPORTED:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-ENGINE_NOT_SUPPORTED"));
                                            break;
                                            default:
                                            break;
                                         };
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-%d,%d,%d,%d",
                                         TST_ATP_CRYS_version.LLF_AES_Version.major,
                                         TST_ATP_CRYS_version.LLF_AES_Version.minor,
                                         TST_ATP_CRYS_version.LLF_AES_Version.sub,
                                         TST_ATP_CRYS_version.LLF_AES_Version.internal));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n CRYS LLF_DES_Version  - %c%c%c",
                                         TST_ATP_CRYS_version.LLF_DES_Version.compName[0],
                                         TST_ATP_CRYS_version.LLF_DES_Version.compName[1],
                                         TST_ATP_CRYS_version.LLF_DES_Version.compName[2]));
                                         switch(TST_ATP_CRYS_version.LLF_DES_Version.type)
                                         {
                                            case CRYS_DEFS_SW_ENGINE_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-SW_ENGINE"));
                                            break;
                                            case CRYS_DEFS_CC_LITE_ENGINE_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-CC_LITE_ENGINE"));
                                            break;
                                            case CRYS_DEFS_CC_LITE_PKI256_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-CC_LITE_PKI256"));
                                            break;
                                            case CRYS_DEFS_SSDMA_ENGINE_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-SSDMA_ENGINE"));
                                            break;
                                            case CRYS_DEFS_SSDMA_2_ENGINE_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-SSDMA_2_ENGINE"));
                                            break;
                                            case CRYS_DEFS_NOT_SUPPORTED:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-ENGINE_NOT_SUPPORTED"));
                                            break;
                                            default:
                                            break;
                                         };
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-%d,%d,%d,%d",
                                         TST_ATP_CRYS_version.LLF_DES_Version.major,
                                         TST_ATP_CRYS_version.LLF_DES_Version.minor,
                                         TST_ATP_CRYS_version.LLF_DES_Version.sub,
                                         TST_ATP_CRYS_version.LLF_DES_Version.internal));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n CRYS LLF_PKI_Version  - %c%c%c",
                                         TST_ATP_CRYS_version.LLF_PKI_Version.compName[0],
                                         TST_ATP_CRYS_version.LLF_PKI_Version.compName[1],
                                         TST_ATP_CRYS_version.LLF_PKI_Version.compName[2]));
                                         switch(TST_ATP_CRYS_version.LLF_PKI_Version.type)
                                         {
                                            case CRYS_DEFS_SW_ENGINE_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-SW_ENGINE"));
                                            break;
                                            case CRYS_DEFS_CC_LITE_ENGINE_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-CC_LITE_ENGINE"));
                                            break;
                                            case CRYS_DEFS_CC_LITE_PKI256_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-CC_LITE_PKI256"));
                                            break;
                                            case CRYS_DEFS_SSDMA_ENGINE_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-SSDMA_ENGINE"));
                                            break;
                                            case CRYS_DEFS_SSDMA_2_ENGINE_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-SSDMA_2_ENGINE"));
                                            break;
                                            case CRYS_DEFS_NOT_SUPPORTED:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-ENGINE_NOT_SUPPORTED"));
                                            break;
                                            default:
                                            break;
                                         };
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-%d,%d,%d,%d",
                                         TST_ATP_CRYS_version.LLF_PKI_Version.major,
                                         TST_ATP_CRYS_version.LLF_PKI_Version.minor,
                                         TST_ATP_CRYS_version.LLF_PKI_Version.sub,
                                         TST_ATP_CRYS_version.LLF_PKI_Version.internal));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n CRYS LLF_RND_Version  - %c%c%c",
                                         TST_ATP_CRYS_version.LLF_RND_Version.compName[0],
                                         TST_ATP_CRYS_version.LLF_RND_Version.compName[1],
                                         TST_ATP_CRYS_version.LLF_RND_Version.compName[2]));
                                         switch(TST_ATP_CRYS_version.LLF_RND_Version.type)
                                         {
                                            case CRYS_DEFS_SW_ENGINE_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-SW_ENGINE"));
                                            break;
                                            case CRYS_DEFS_CC_LITE_ENGINE_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-CC_LITE_ENGINE"));
                                            break;
                                            case CRYS_DEFS_CC_LITE_PKI256_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-CC_LITE_PKI256"));
                                            break;
                                            case CRYS_DEFS_SSDMA_ENGINE_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-SSDMA_ENGINE"));
                                            break;
                                            case CRYS_DEFS_SSDMA_2_ENGINE_TYPE:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-SSDMA_2_ENGINE"));
                                            break;
                                            case CRYS_DEFS_NOT_SUPPORTED:
                                            ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-ENGINE_NOT_SUPPORTED"));
                                            break;
                                            default:
                                            break;
                                         };
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"-%d,%d,%d,%d",
                                         TST_ATP_CRYS_version.LLF_RND_Version.major,
                                         TST_ATP_CRYS_version.LLF_RND_Version.minor,
                                         TST_ATP_CRYS_version.LLF_RND_Version.sub,
                                         TST_ATP_CRYS_version.LLF_RND_Version.internal));
    ATP_LOG_TST_PRINT((CRYS_ATP_TST_MSG,"\n-----------------------------------------------------------------"));

}




